/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8224;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.AccessDenied;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.eui.WrongSysOidMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8224.UnitData;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.CookieTray;
import ibm.nways.widgets.WidgetCookie;
import java.awt.Component;
import java.awt.Label;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class BoxInfo {
    private static String bundleName = "ibm.nways.jdm8224.Resources";
    private static ResourceBundle myResources = ResourceBundle.getBundle(bundleName);
    private static ResourceBundle commonResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.CommonFolderGroupResources");
    public static final String PROPNAME = "BoxInfo.jdm8224.nways.ibm";
    protected static final String PropertiesFile = "properties/Jdm8224.txt";
    public static final String cookiePath = "ibm.nways.jdm8224.WCDefault";
    public static final String gifPath = "/ibm/nways/jdm8224";
    public static final int NoStatus = 0;
    public static final int AllisWell = 1;
    public static final int NotResponding = 2;
    public static final int WrongBox = 3;
    public static final int ServerProblems = 4;
    public static final int SlaveBox = 5;
    public static final OID SysOID_8224 = new OID("1.3.6.1.4.1.2.6.39.0");
    public static final int NumOfRj45 = 16;
    public static final int MepPort = 17;
    private static final int RASID = 19;
    private static final int RASSUB = 1;
    private GenModel deviceModel;
    private JdmBrowser deviceBrowser;
    private int deviceStatus;
    private GraphicPanel deviceGraphic;
    private OID deviceSysOID;
    private int agentVersion;
    private boolean isApplication;
    GenModel systemModel;
    GenModel unitInfoModel;
    GenModel hwConfigModel;
    GenModel portMonitorModel;
    Vector unitsVector;
    public static Hashtable unitHashTable = new Hashtable();
    public Integer ThisNum;
    private boolean disposeCalled;

    public BoxInfo(GenModel genModel, JdmBrowser jdmBrowser) {
        Serializable serializable;
        block36: {
            block35: {
                block34: {
                    this.deviceStatus = 1;
                    this.disposeCalled = false;
                    if (RAS.isEnabled(19, 1)) {
                        RAS.enter(19, 1, this, "BoxInfo constr");
                    }
                    ModelInfo modelInfo = null;
                    Serializable serializable2 = null;
                    this.deviceBrowser = jdmBrowser;
                    this.deviceModel = genModel;
                    myResources = ResourceBundle.getBundle(bundleName);
                    unitHashTable.clear();
                    this.deviceBrowser.displayMsg(BoxInfo.getNLSString("CheckDevice"));
                    try {
                        modelInfo = this.deviceModel.getInfo("Initial");
                        serializable2 = modelInfo.get("Initial.SysObjectID");
                        if (serializable2 instanceof Timeout || serializable2 instanceof NotSupported || serializable2 instanceof AccessDenied) {
                            this.deviceStatus = 2;
                            if (RAS.isEnabled(19, 1)) {
                                RAS.logError(19, 1, this, "BoxInfo constr", "Device not responding");
                            }
                            new BoxDownMsg(jdmBrowser.getFrame(), BoxInfo.getNLSString("deviceName"));
                        } else {
                            this.deviceSysOID = new OID(serializable2.toString());
                            if (!this.deviceSysOID.equals(SysOID_8224)) {
                                if (RAS.isEnabled(19, 1)) {
                                    RAS.logError(19, 1, this, "BoxInfo constr", "Wrong SysOid. Device is not 8224");
                                }
                                this.deviceStatus = 3;
                                new WrongSysOidMsg(this.deviceBrowser.getFrame(), BoxInfo.getNLSString("deviceName"));
                            } else {
                                this.deviceStatus = 1;
                            }
                        }
                    }
                    catch (Exception exception) {
                        RAS.logException(19, 1, this, "BoxInfo constr", exception);
                        this.deviceStatus = 4;
                        if (!RAS.isEnabled(19, 1)) break block34;
                        RAS.logError(19, 1, this, "BoxInfo constr", "Error getting SysOid");
                    }
                }
                if (this.deviceStatus == 1) {
                    this.deviceBrowser.displayMsg(BoxInfo.getNLSString("GetMoreDeviceInfo"));
                    try {
                        this.hwConfigModel = (GenModel)this.deviceModel.getComponent("Configuration");
                        this.unitInfoModel = (GenModel)this.deviceModel.getComponent("Units");
                    }
                    catch (Exception exception) {
                        RAS.logException(19, 1, this, "BoxInfo constr", exception);
                        this.deviceStatus = 4;
                        if (!RAS.isEnabled(19, 1)) break block35;
                        RAS.logError(19, 1, this, "BoxInfo constr", "Error Getting Box Information(Configuration Info, UnitsInformation Info)");
                    }
                }
            }
            if (this.deviceStatus == 1) {
                try {
                    serializable = this.hwConfigModel.getInfo("Panel", "default", null);
                    if (serializable == null) {
                        if (RAS.isEnabled(19, 1)) {
                            RAS.trace(19, 1, this, "BoxInfo constr", "Cannot get Panel info. res == null");
                        }
                    } else {
                        Serializable serializable3 = ((ModelInfo)serializable).get("Panel.Ibm8224ThisNmm");
                        this.ThisNum = (Integer)serializable3;
                        if (RAS.isEnabled(19, 1)) {
                            RAS.trace(19, 1, this, "BoxInfo constr", "ThisNum: " + this.ThisNum.toString());
                        }
                    }
                }
                catch (Exception exception) {
                    RAS.logException(19, 1, this, "BoxInfo constr", exception);
                    this.deviceStatus = 4;
                    if (!RAS.isEnabled(19, 1)) break block36;
                    RAS.trace(19, 1, this, "BoxInfo", "Error getting hwConfigInfo");
                }
            }
        }
        if (this.deviceStatus == 1 || this.deviceStatus == 5) {
            block37: {
                try {
                    this.unitsVector = this.unitInfoModel.getRestOfInfo("Panel", "default", null, null);
                    if (this.unitsVector != null) {
                        serializable = new Integer(this.unitsVector.size());
                        if (RAS.isEnabled(19, 1)) {
                            RAS.trace(19, 1, this, "BoxInfo constr", "Number of boxes in the stack is " + ((Integer)serializable).toString());
                        }
                        int n = 0;
                        while (n < this.unitsVector.size()) {
                            Serializable serializable4;
                            ModelInfo modelInfo = (ModelInfo)this.unitsVector.elementAt(n);
                            if (RAS.isEnabled(19, 1)) {
                                RAS.trace(19, 1, this, "BoxInfo constr", "\nselectedRow is: " + modelInfo.toString());
                            }
                            if (!((serializable4 = modelInfo.get("Index.StackIndex")) instanceof Integer)) {
                                if (RAS.isEnabled(19, 1)) {
                                    RAS.trace(19, 1, this, "BoxInfo constr", "Wrong Index - Timeout might have occured");
                                }
                                this.deviceStatus = 2;
                            } else {
                                UnitData unitData = this.getUnitData(modelInfo);
                                unitHashTable.put(unitData.ID, unitData);
                                if (unitData.ID.intValue() == this.ThisNum.intValue() && !unitData.IsThisManaged) {
                                    if (RAS.isEnabled(19, 1)) {
                                        RAS.trace(19, 1, this, "BoxInfo constr", "This is Slave box which does not give enough info!");
                                    }
                                    this.deviceStatus = 5;
                                }
                            }
                            ++n;
                        }
                    } else {
                        this.deviceStatus = 2;
                        if (RAS.isEnabled(19, 1)) {
                            RAS.trace(19, 1, this, "BoxInfo", "Vector null. Set deviceStatus NotResponding. Vector:= unitsInfoModel.getRestOfInfo");
                        }
                    }
                }
                catch (Exception exception) {
                    RAS.logException(19, 1, this, "BoxInfo constr", exception);
                    this.deviceStatus = 4;
                    if (!RAS.isEnabled(19, 1)) break block37;
                    RAS.trace(19, 1, this, "BoxInfo", "Error getting information of each modules");
                }
            }
            if (RAS.isEnabled(19, 1)) {
                RAS.exit(19, 1, this, "BoxInfo", (Object)("deviceStatus=" + this.deviceStatus));
            }
        }
    }

    private UnitData getUnitData(ModelInfo modelInfo) {
        Object object;
        UnitData unitData;
        block21: {
            if (RAS.isEnabled(19, 1)) {
                RAS.enter(19, 1, this, "getUnitData");
            }
            unitData = new UnitData();
            unitData.selectedRow = modelInfo;
            try {
                unitData.rowModel = (GenModel)this.unitInfoModel.getRowRef(modelInfo).getComponent("UnitsInformation");
                object = (GenModel)unitData.rowModel.getComponent("Port");
                unitData.portInfoModel = (GenModel)object.getComponent("PortInformation");
                unitData.systemModel = (GenModel)unitData.rowModel.getComponent("System");
                unitData.portMonitorModel = unitData.portInfoModel;
            }
            catch (Exception exception) {
                RAS.logException(19, 1, this, "getUnitData", exception);
                if (!RAS.isEnabled(19, 1)) break block21;
                RAS.logError(19, 1, this, "getUnitData", "Error getting rowModel/systemInfo for each row");
            }
        }
        object = modelInfo.get("Index.StackIndex");
        Serializable serializable = modelInfo.get("Panel.IpAddr");
        Serializable serializable2 = modelInfo.get("Panel.BkplNum");
        Serializable serializable3 = modelInfo.get("Panel.ModuleType");
        unitData.ipAddress = serializable.toString();
        unitData.bkplNum = (Integer)serializable2;
        switch (unitData.bkplNum) {
            case 1: {
                unitData.IsThisConnectedToBackplane = true;
                break;
            }
            case 6: {
                unitData.IsThisConnectedToBackplane = false;
                break;
            }
        }
        unitData.unitType = (Integer)serializable3;
        switch (unitData.unitType) {
            case 1: 
            case 2: 
            case 52: {
                unitData.MEP = "empty";
                break;
            }
            case 3: 
            case 7: 
            case 53: 
            case 57: {
                unitData.MEP = "aui";
                break;
            }
            case 4: 
            case 8: 
            case 54: 
            case 58: {
                unitData.MEP = "bnc";
                break;
            }
            case 5: 
            case 9: 
            case 55: 
            case 59: {
                unitData.MEP = "fiber";
                break;
            }
            case 6: 
            case 56: {
                if (RAS.isEnabled(19, 1)) {
                    RAS.trace(19, 1, this, "getUnitData", "UTP found for MEP");
                }
            }
            case 1000: {
                unitData.MEP = "unknown";
                break;
            }
        }
        switch (unitData.unitType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                unitData.IsThisManaged = true;
                break;
            }
        }
        unitData.ID = (Integer)object;
        if (unitData.ID.intValue() == this.ThisNum.intValue()) {
            unitData.IsThisThisModule = true;
        }
        if (RAS.isEnabled(19, 1)) {
            RAS.exit(19, 1, this, "getUnitData");
        }
        return unitData;
    }

    public static void setInNavContext(NavigationContext navigationContext, BoxInfo boxInfo) {
        navigationContext.put((Object)PROPNAME, (Object)boxInfo);
    }

    public static BoxInfo getFromNavContext(NavigationContext navigationContext, boolean bl) {
        return (BoxInfo)navigationContext.get((Object)PROPNAME, bl);
    }

    public JdmBrowser getDeviceBrowser() {
        return this.deviceBrowser;
    }

    public int getDeviceStatus() {
        return this.deviceStatus;
    }

    public GenModel getDeviceModel() {
        return this.deviceModel;
    }

    public int getAgentVersion() {
        return this.agentVersion;
    }

    public GraphicPanel getDeviceGraphic() {
        String string;
        Object[] objectArray;
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        int n2 = 0;
        if (RAS.isEnabled(19, 1)) {
            RAS.enter(19, 1, this, "getDeviceGraphic");
        }
        Properties properties = null;
        if (this.deviceGraphic != null) {
            return this.deviceGraphic;
        }
        try {
            object4 = new URL(this.deviceBrowser.getDocumentBase(), PropertiesFile);
            properties = new Properties();
            properties.load(((URL)object4).openStream());
        }
        catch (Exception exception) {
            RAS.logError(19, 1, this, "getDeviceGraphic", "EXCEPTION_GETTING_PROPERTIES", (Object)(String.valueOf(this.deviceBrowser.getDocumentBase()) + PropertiesFile));
            RAS.logException(19, 1, this, "getDeviceGraphic", exception);
        }
        JdmLayout jdmLayout = (JdmLayout)this.deviceBrowser.getLayout();
        if (properties != null) {
            object4 = (String)((Hashtable)properties).get("layout.scheme");
            if (RAS.isEnabled(19, 1)) {
                RAS.trace(19, 1, this, "getDeviceGraphic", "layout.scheme =" + (String)object4);
            }
            object3 = new Integer((String)((Hashtable)properties).get("layout.scheme"));
            if (RAS.isEnabled(19, 1)) {
                RAS.trace(19, 1, this, "getDeviceGraphic", "The layout scheme prpt = " + object3);
            }
            n = (Integer)object3;
            jdmLayout.setScheme(n);
            object2 = (String)((Hashtable)properties).get("layout.fractions");
            object = new StringTokenizer((String)object2);
            objectArray = new float[((StringTokenizer)object).countTokens()];
            boolean bl = true;
            int n3 = 0;
            while (n3 < objectArray.length && ((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken();
                try {
                    objectArray[n3] = Float.valueOf(string).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    RAS.logError(19, 1, this, "getDeviceGraphic", "EXCEPTION_CALCULATING_FRACTIONS", (Object)numberFormatException);
                    RAS.logException(19, 1, this, "getDeviceGraphic", (Exception)numberFormatException);
                    bl = false;
                }
                ++n3;
            }
            if (bl) {
                jdmLayout.setFracts(objectArray);
            }
        } else {
            n = 0;
            jdmLayout.setScheme(n);
        }
        GraphicContainer graphicContainer = new GraphicContainer();
        if (this.disposeCalled) {
            return null;
        }
        object4 = new GraphicHelp((BrowserApplet)this.deviceBrowser, new Point(0, 0), new HelpRef((Object)this));
        graphicContainer.add((GraphicComponent)object4);
        if ((this.deviceStatus == 1 || this.deviceStatus == 5) && this.unitsVector != null) {
            object3 = unitHashTable.elements();
            while (object3.hasMoreElements()) {
                CookieTray cookieTray;
                block40: {
                    Label label;
                    object2 = (UnitData)object3.nextElement();
                    if (this.disposeCalled) {
                        return null;
                    }
                    object = new MessageFormat(BoxInfo.getNLSString("BuildGraphic"));
                    objectArray = new Object[2];
                    objectArray[0] = (float)((UnitData)object2).ID.toString();
                    Integer n4 = new Integer(this.unitsVector.size());
                    objectArray[1] = (float)n4.toString();
                    this.deviceBrowser.displayMsg(((Format)object).format(objectArray));
                    String string2 = "Chasis" + ((UnitData)object2).ID.toString() + "flyover";
                    if (((UnitData)object2).ID > 0) {
                        n2 = 100 * (((UnitData)object2).ID - 1);
                    }
                    string = "/ibm/nways/jdm8224/8224.gif";
                    if (RAS.isEnabled(19, 1)) {
                        RAS.trace(19, 1, this, "BoxInfo", "Going to create cookie tray....gifName=" + string);
                    }
                    cookieTray = new CookieTray(bundleName, new Point(120, n2), string, string2, this.deviceBrowser, ((UnitData)object2).systemModel, "ibm.nways.mib2.eui.SystemPanel");
                    MessageFormat messageFormat = new MessageFormat(BoxInfo.getNLSString("UNIT_LABEL"));
                    Object[] objectArray2 = new Object[]{((UnitData)object2).ID.toString()};
                    String string3 = messageFormat.format(objectArray2);
                    Label label2 = new Label(string3);
                    label2.setLocation(new Point(17, n2 + 10));
                    graphicContainer.add(label2);
                    if (((UnitData)object2).IsThisManaged) {
                        label = new Label(BoxInfo.getNLSString("MASTER_LABEL"));
                        label.setLocation(new Point(17, n2 + 25));
                        graphicContainer.add(label);
                    } else {
                        label = new Label(BoxInfo.getNLSString("SLAVE_LABEL"));
                        label.setLocation(new Point(17, n2 + 25));
                        graphicContainer.add(label);
                    }
                    if (((UnitData)object2).ipAddress.equals("0.0.0.0")) {
                        label = new Label(BoxInfo.getNLSString("noIpAddress"));
                        label.setLocation(new Point(102, n2 + 62));
                        graphicContainer.add(label);
                    } else {
                        string3 = ((UnitData)object2).IsThisThisModule ? String.valueOf(((UnitData)object2).ipAddress) + "*" : ((UnitData)object2).ipAddress;
                        label = new Label(string3);
                        label.setLocation(new Point(17, n2 + 45));
                        graphicContainer.add(label);
                    }
                    if (this.disposeCalled) {
                        return null;
                    }
                    WidgetCookie widgetCookie = new WidgetCookie("rs232c", "ibm.nways.jdm8224.Resources", null, cookiePath, null, this.deviceBrowser, 22);
                    widgetCookie.setLocation(new Point(466, 36));
                    cookieTray.AddWidget(widgetCookie);
                    WidgetCookie widgetCookie2 = new WidgetCookie("hep", "ibm.nways.jdm8224.Resources", null, cookiePath, null, this.deviceBrowser, 22);
                    widgetCookie2.setLocation(new Point(516, 30));
                    cookieTray.AddWidget(widgetCookie2);
                    if (this.disposeCalled) {
                        return null;
                    }
                    try {
                        Serializable serializable;
                        WidgetCookie widgetCookie3;
                        WidgetCookie widgetCookie4;
                        Object object5;
                        Serializable serializable2;
                        if (((UnitData)object2).ipAddress.equals("0.0.0.0")) {
                            if (RAS.isEnabled(19, 1)) {
                                RAS.trace(19, 1, this, "BoxInfo", "0.0.0.0 found as IP Address. One of the boxes are NOT CONFIGURED. JMA will not attach status/action");
                            }
                            int n5 = 1;
                            while (n5 <= 16) {
                                serializable2 = new ModelInfo();
                                ((ModelInfo)serializable2).add("Index.PortId", new Integer(n5));
                                object5 = new ModelInfo();
                                object5.add("Index.Ibm8224ExtendedPortId", new Integer(n5));
                                widgetCookie4 = new WidgetCookie("rj45w", "ibm.nways.jdm8224.Resources", (ModelInfo)object5, cookiePath, null, this.deviceBrowser, 22);
                                if (n5 <= 8) {
                                    widgetCookie4.setLocation(new Point(96 + n5 * 19, 33));
                                } else {
                                    widgetCookie4.setLocation(new Point(252 + (n5 - 8) * 19, 33));
                                }
                                cookieTray.AddWidget(widgetCookie4);
                                ++n5;
                            }
                            if (RAS.isEnabled(19, 1)) {
                                RAS.trace(19, 1, this, "BoxInfo", "Media Expansion Port is" + ((UnitData)object2).MEP);
                            }
                            if (!((UnitData)object2).MEP.equals("empty")) {
                                serializable2 = new ModelInfo();
                                ((ModelInfo)serializable2).add("Index.PortId", new Integer(17));
                                object5 = ((UnitData)object2).MEP;
                                widgetCookie3 = new WidgetCookie((String)object5, "ibm.nways.jdm8224.Resources", null, cookiePath, null, this.deviceBrowser, 22);
                                widgetCookie3.setLocation(new Point(4, 21));
                                cookieTray.AddWidget(widgetCookie3);
                            }
                            break block40;
                        }
                        int n6 = 1;
                        while (n6 <= 16) {
                            serializable2 = new MessageFormat(BoxInfo.getNLSString("PollPorts"));
                            object5 = new Object[2];
                            serializable = new Integer(n6);
                            object5[0] = ((UnitData)object2).ID.toString();
                            object5[1] = ((Integer)serializable).toString();
                            this.deviceBrowser.displayMsg(((Format)serializable2).format(object5));
                            ModelInfo modelInfo = new ModelInfo();
                            modelInfo.add("Index.PortId", new Integer(n6));
                            try {
                                ModelInfo modelInfo2 = new ModelInfo();
                                modelInfo2.add("Index.Ibm8224ExtendedPortId", new Integer(n6));
                                widgetCookie4 = new WidgetCookie("port", "ibm.nways.jdm8224.Resources", modelInfo2, cookiePath, ((UnitData)object2).portMonitorModel, this.deviceBrowser, 18);
                                ModelInfo modelInfo3 = new ModelInfo();
                                modelInfo3.add("Index.Ibm8224ExtendedPortId", new Integer(n6));
                                widgetCookie4.SetAction(((UnitData)object2).portInfoModel, modelInfo3, "ibm.nways.jdm8224.eui.PortInformationBasePanel");
                                Integer n7 = new Integer(n6);
                                String string4 = "port" + n7.toString() + "flyover";
                                widgetCookie4.SetFlyover(string4);
                                if (n6 <= 8) {
                                    widgetCookie4.setLocation(new Point(96 + n6 * 19, 33));
                                } else {
                                    widgetCookie4.setLocation(new Point(252 + (n6 - 8) * 19, 33));
                                }
                                cookieTray.AddWidget(widgetCookie4);
                            }
                            catch (Exception exception) {}
                            ++n6;
                        }
                        if (RAS.isEnabled(19, 1)) {
                            RAS.trace(19, 1, this, "BoxInfo", "unitData.MEP=" + ((UnitData)object2).MEP);
                        }
                        if (!((UnitData)object2).MEP.equals("empty")) {
                            serializable2 = new ModelInfo();
                            ((ModelInfo)serializable2).add("Index.Ibm8224ExtendedPortId", new Integer(17));
                            object5 = ((UnitData)object2).MEP;
                            widgetCookie3 = new WidgetCookie((String)object5, "ibm.nways.jdm8224.Resources", (ModelInfo)serializable2, cookiePath, ((UnitData)object2).portMonitorModel, this.deviceBrowser, 18);
                            serializable = new ModelInfo();
                            ((ModelInfo)serializable).add("Index.Ibm8224ExtendedPortId", new Integer(17));
                            widgetCookie3.SetAction(((UnitData)object2).portInfoModel, (ModelInfo)serializable, "ibm.nways.jdm8224.eui.PortInformationBasePanel");
                            widgetCookie3.SetFlyover(String.valueOf(object5) + "flyover");
                            widgetCookie3.setLocation(new Point(4, 21));
                            cookieTray.AddWidget(widgetCookie3);
                        }
                    }
                    catch (Exception exception) {}
                }
                graphicContainer.add((GraphicContainer)cookieTray);
                if (!RAS.isEnabled(19, 1)) continue;
                RAS.trace(19, 1, this, "getDeviceGraphic", "Tray added for a box");
            }
        }
        return new GraphicPanel((GraphicHandler)this.deviceBrowser, (Component)graphicContainer);
    }

    public void dispose() {
        this.disposeCalled = true;
        if (this.deviceGraphic != null) {
            this.deviceGraphic.dispose();
            this.deviceGraphic = null;
        }
        this.systemModel = null;
        this.unitInfoModel = null;
        this.hwConfigModel = null;
        this.portMonitorModel = null;
        this.unitsVector = null;
        this.deviceBrowser = null;
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            try {
                string2 = commonResources.getString(string);
            }
            catch (Exception exception2) {
                string2 = string;
            }
        }
        return string2;
    }
}

